﻿
''' <summary>
''' -----------------------------------------------------------------------------
''' ATUpdater使用のサンプルコード(VB.NET)
''' お客様が開発したシステムへロジックを記述する際にご参考くださいませ。
''' -----------------------------------------------------------------------------
''' 亜洲トークン株式会社　http://www.ashutoken.jp/
''' -----------------------------------------------------------------------------
''' </summary>
''' <remarks></remarks>
Public Class Sample

    ''' <summary>
    ''' フォームがロードされた直後のイベントハンドラです。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ATUpdaterSample_Shown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown

        Try

            ' この実行ファイルのバージョン
            Dim thisAppVersion As String = "1.00"

            Label2.Text = thisAppVersion

            ' -----------------------------------------------------------
            ' WEBサイトに新しいバージョンがあるかどうかをチェックします。
            ' -----------------------------------------------------------
            Dim downloadUrl As String = ""
            If IsExistNewVersion(thisAppVersion, downloadUrl) Then

                ' --------------------------------
                ' 現行と異なるバージョンがある場合
                ' --------------------------------

                MessageBox.Show("最新バージョンが発行されています。" & vbCrLf & "アップデート（更新処理）を実行します。", "お知らせ", MessageBoxButtons.OK, MessageBoxIcon.Information)

                ' 開発システム(Sample.exe)の実行ディレクトリと、ATUpdater.exeのフルパスを生成
                Dim execDir As String = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().CodeBase).Replace("file:\", "")
                Dim execFile As String = System.IO.Path.Combine(execDir, "ATUpdater\ATUpdater.exe")

                ' ATUpdater.exeを3引数付きで実行
                ' -----------------------------------------------------------------------------------------------
                ' ATUpdater.exe "システム名" "version.txtに記述しているダウンロードURL" "zipファイルのパスワード"
                ' -----------------------------------------------------------------------------------------------
                System.Diagnostics.Process.Start(execFile, "○○システム" & " " & downloadUrl & " " & "sample")

                ' 自身プロセスの終了
                Me.Close()
                End

            End If

        Catch ex As Exception

            MessageBox.Show(ex.Message, "例外エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)

        End Try

    End Sub

    ''' <summary>
    ''' WEBサイトに新しいバージョンがあるかどうかをチェックします。
    ''' </summary>
    ''' <param name="strCurrentVersion">実行中システムのバージョンを示す文字列です。</param>
    ''' <param name="downloadUrl">実行中システムのバージョンが、WEBサイトに置いてあるバージョンと異なっている場合、そのダウンロード先URL文字列を格納します。</param>
    ''' <returns></returns>
    Private Function IsExistNewVersion(ByVal strCurrentVersion As String, ByRef downloadUrl As String) As Boolean

        Try

            ' ---------------------------------------------------------------------------------------------------------------
            ' 開発システムの最新バージョン情報ファイル(version.txt)
            ' ---------------------------------------------------------------------------------------------------------------
            ' サンプルではtxtファイルの中身は以下になっています。
            ' 一行目に現在WEBに置いている最新システムのバージョン文字列
            ' 二行目に開発システムのZIPファイルURLが記述されています。
            ' ---------------------------------------------------------------------------------------------------------------
            ' 2.00
            ' http://www.ashutoken.jp/atupdater/sample/atupdater_sample_ver200.zip
            ' ---------------------------------------------------------------------------------------------------------------

            Dim url As String = "http://www.ashutoken.jp/atupdater/sample/version.txt"


            Dim tmpFileName As String = System.IO.Path.GetTempFileName()

            Using wc As New System.Net.WebClient()

                ' WEBに置いたバージョン情報ファイルの取得
                wc.DownloadFile(url, tmpFileName)

            End Using

            ' 取得したテキストファイルの解析
            Dim strVer As String = ""
            Dim strUrl As String = ""
            Using sr As New System.IO.StreamReader(tmpFileName)

                ' 内容を一行ずつ読み込む
                strVer = sr.ReadLine()  ' 一行目
                strUrl = sr.ReadLine()  ' 二行目
                sr.Close()

            End Using

            ' バージョン文字列の比較
            If Not strCurrentVersion.Equals(strVer) Then

                ' 現行と異なるバージョンがあります。→ 取得したダウンロードURLを返します。
                downloadUrl = strUrl
                Return True

            Else

                ' 現行と同じバージョンです。
                Return False

            End If

        Catch ex As Exception

            ' ネットワークに接続していない、ファイルが存在しないなどの例外は、全て false を返しています。
            ' （現行と異なるバージョンは見つからなかったものとして処理を進めます。）
            Return False

        End Try

    End Function

End Class